#pragma rtGlobals=1		// Use modern global access method.
#include <Strings as Lists>

menu "Data"
	"-"
	Submenu "LS230"
		"Open LS230"
		"Change LS230 Qwaves"
	end
end

Macro openLS230()

	|DoAlert 0,"Data must be in tab-delimited format \r Close all tables and plots to reload \rChange file type to TEXT"
	variable refno=2,time1
	Silent 1
	Open /D/R refNo             //open dialog and load s_filename, but not open file
		getfilename(s_filename)
	Open /R refNo as s_filename          //opens without dialog
		variable Counter=0     //put initial lines in notes are of wave
		String LineOfNote,TheNote
		TheNote+=gfullpath+"\r\r"
		do
			FReadLine refNo, LineOfNote
			TheNote+=LineOfNote
			Counter+=1
		while(Counter<17)
		
	LoadWave/J/W/D/N/O/E=1/K=0/V={"\t"," $",0,0}/L={9,11,0,1,0}  s_filename

	string, bwave ="bkg"+gfilename ,rwave ="r"+gfilename ,owave= "offset"+gfilename,qwave="q"+gfilename
	print rwave
	KillWaves/Z $bwave;KillWaves/Z $rwave;KillWaves/Z $owave;KillWaves/Z $qwave
	Rename Detector,$rwave
	//Rename background,$bwave;Rename offsets,$owave;
	make $qwave=root:'Startup:qforLS230
	
	Note $rwave TheNote

	display $rwave vs $qwave
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	ShowInfo
	openLS230()
end


Macro ChangeLS230Qwaves(File,MaximumStrLen)
	String File="Q44424_600"
	Variable MaximumStrLen=30
	Prompt File,"File for first letter match",popup,WaveList("Q*", ";", "")
	Prompt MaximumStrLen,"Enter the maximum length of a wave name:"
	
	DoAlert 2,"changes all qwaves to QforLS230 in startup folder\rmake sure your pointing to right data folder"
	Silent 1
	String ListofWaves,FirstLetter
	Variable Length,NumberofWaves,ListCurser,Counter
	Length=MaximumStrLen| Strlen(File)
	FirstLetter=File[0,0]
	ListofWaves=WaveList(FirstLetter+"*", ";", "")
	NumberofWaves=round(Strlen(ListofWaves)/(Strlen(File)-2))
	ListCurser=(-1-Length)
	iterate(NumberofWaves)
		ListCurser=ListCurser+(1+Length)
		File=ListofWaves[ListCurser,(ListCurser+(Length-1))]
		Counter=0
		do
			if(CmpStr(File[Counter],";")==0)
				File=File[0,(Counter-1)]
				ListCurser=ListCurser+Counter-Length
				Counter=Length
			endif
			Counter=Counter+1
		while (Counter<(Length))
		if ((exists(File))==1)
			$File=root:startup:QforLS230
			Print File+" is converted"
		else
			print File+" does not exist as a wave"
		endif
	loop
EndMacro
